<!doctype html>
<html>

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=yes">
  <link rel="icon" type="image/x-icon" href="favicon.ico">
  <link rel="stylesheet" media="all" href="style.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/highlight.js/11.9.0/styles/default.min.css">
  <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/highlight.js/11.9.0/highlight.min.js"></script>
  <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/highlight.js/11.9.0/languages/maxima.min.js"></script>
  <script type="text/javascript" src="yamwi.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.9.2/html2pdf.bundle.min.js"></script>

  <title>Maxima Online 2</title>
</head>

<body>

<a href="index.php" class="homepage">
  <img src="logo.jpg" alt="Maxima Online 2 Logo" style="height: 4em; width: auto;">
</a>
<!--  
<h1><a href="index.php" class="homepage"><i>Maxima Online 2</i></a></h1>
-->
<p class="small-right">Maxima Online 2 : 
<a href="help/help_fr.html" target="_blank">Guide pratique</a>
</p>
<p class="small-right">Maxima : 
<a href="help/aidememoiremaxima2.pdf" target="_blank">Aide mémoire 1 (Yves Lemaire)</a>
</p>
<p class="small-right">Maxima : 
<a href="help/aidememoiremaxima.pdf" target="_blank">Aide mémoire 2 (Vincent Obation)</a>
</p>

<button id="expand-btn">Développer</button>
<button id="factoriser">Factoriser</button>
<button id="simplifier1">Simplifier fraction</button>
<button id="simplifier2">Simplifier trigonométrie</button>
<button id="simplifier3">Simplifier racines-log</button>
<button id="simplifier4">Développer trigonométrie</button>
<button id="simplifier5">Simplifier totalement fraction</button>
<button id="simplifier6">Numérateur fraction</button>
<button id="simplifier7">Dénominateur fraction</button>
<br>
<button id="resoudre1">Résoudre équation</button> 
<button id="resoudre2">Résoudre numérique</button> 
<button id="resoudre3">Racines réelles polynôme</button> 
<button id="resoudre4">Racines polynôme</button> 
<button id="resoudre5">Résoudre système linéaire</button> 
<button id="resoudre6">Résoudre système </button> 
<button id="resoudre7">Substitution </button> 
<br>
<button id="derive1">Dérivée</button> 
<button id="derive2">Dérivée n-ième</button> 
<button id="derive3">Intégrale</button> 
<button id="derive4">Intégrale définie</button> 
<button id="derive5">Intégration Rish</button> 
<button id="derive6">Intégration Romberg</button>
<button id="derive7">Définir fonction f(x)</button>
<br>
<button id="ana1">Limite</button>
<button id="ana2">Somme</button>
<button id="ana3">Produit</button>
<button id="ana4">Décomposition éléments simples</button>
<button id="ana5">Série de Taylor</button>
<button id="ana6">PGCD</button>
<br>
<button id="plot1">Courbe 2D cartésienne</button>
<button id="plot2">Courbe 2D paramétrique</button>
<button id="plot3">Courbe 2D implicite</button>
<button id="plot4">Surface 3D </button>

<hr>


<?php
include('yamwi.php');

$default_code =
   "expand((x-2)^3*(x+1/3)^2);\n".
   "solve(x^2-x+2=0);\n".
   "invert(matrix([2,3,1], [a,0,0], [1,4,8]));\n".
   "integrate(x * sin(x), x);\n".
   "draw3d(explicit(x^2+y^2,x,-1,1,y,-1,1));\n".
   "plot2d(exp(-x)*sin(x),[x,0,2*%pi]);";

start($default_code);
?>


<hr>

<button id="btn-pdf">Enregistrer en PDF</button>

<script>
document.getElementById('btn-pdf').addEventListener('click', function () {
    // On capture tout le body (ou une zone spécifique si besoin)
    const element = document.body;

    const opt = {
        margin:       10,
        filename:     'resultats-maxima.pdf',
        image:        { type: 'jpeg', quality: 0.98 },
        html2canvas:  { scale: 2 },
        jsPDF:        { unit: 'mm', format: 'a4', orientation: 'portrait' }
    };

    html2pdf().set(opt).from(element).save();
});
</script>

<button id="saveBtn">Sauvegarder les commandes (.mac)</button>
<script>
// Fonction pour sauvegarder le contenu de la textarea "max"
document.getElementById("saveBtn").addEventListener("click", function() {
    var textarea = document.getElementById("max");
    if (!textarea) {
        alert("La zone de texte 'max' est introuvable !");
        return;
    }
    var contenu = textarea.value;
    var blob = new Blob([contenu], {type: "text/plain"});
    var link = document.createElement("a");
    link.href = URL.createObjectURL(blob);
    link.download = "yamwi_commandes.mac";
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
    URL.revokeObjectURL(link.href);
});
</script>

<button id="loadFileBtn">Charger des commandes (.mac)</button>
<input type="file" id="fileInput" accept=".mac" style="display:none" />

<script>
const loadFileBtn = document.getElementById('loadFileBtn');
const fileInput = document.getElementById('fileInput');
const textarea = document.getElementById('max');  // utilise la textarea unique

loadFileBtn.addEventListener('click', () => {
  fileInput.click();
});

fileInput.addEventListener('change', (event) => {
  const file = event.target.files[0];
  if (file) {
    const reader = new FileReader();
    reader.onload = function(e) {
      textarea.value = e.target.result;  // Remplace le contenu existant
    };
    reader.readAsText(file);
  }
});
</script>

<button id="saveBatchBtn">Enregistrer batch wxmaxima (.mac)</button>
<script>
// Fonction pour sauvegarder le contenu modifié de la textarea "max"
document.getElementById("saveBatchBtn").addEventListener("click", function() {
    var textarea = document.getElementById("max");
    if (!textarea) {
        alert("La zone de texte 'max' est introuvable !");
        return;
    }
    var contenu = textarea.value;
    var lignes = contenu.split('\n');
    for (var i = 0; i < lignes.length; i++) {
        // Remplacer toute commande en début de ligne commençant par 'plot' par 'wxplot'
        lignes[i] = lignes[i].replace(/^plot/, 'wxplot');
        // Remplacer toute commande en début de ligne commençant par 'draw' par 'wxdraw'
        lignes[i] = lignes[i].replace(/^draw/, 'wxdraw');
    }
    var contenuModifie = lignes.join('\n');
    var blob = new Blob([contenuModifie], {type: "text/plain"});
    var link = document.createElement("a");
    link.href = URL.createObjectURL(blob);
    link.download = "batch-wxmaxima.mac";
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
    URL.revokeObjectURL(link.href);
});
</script>

<button onclick="window.scrollTo({top: 0, behavior: 'smooth'});">Retour haut de page</button>

<script src="com01.js"></script>
<script src="com02.js"></script>
<script src="com03.js"></script>
<script src="com04.js"></script>
<script src="com05.js"></script>
<script src="com06.js"></script>
<script src="com07.js"></script>
<script src="com08.js"></script>
<script src="com09.js"></script>
<script src="com10.js"></script>
<script src="com11.js"></script>
<script src="com12.js"></script>
<script src="com13.js"></script>
<script src="com14.js"></script>
<script src="com15.js"></script>
<script src="com16.js"></script>
<script src="com17.js"></script>
<script src="com18.js"></script>
<script src="com19.js"></script>
<script src="com20.js"></script>
<script src="com21.js"></script>
<script src="com22.js"></script>
<script src="com23.js"></script>
<script src="com24.js"></script>
<script src="com25.js"></script>
<script src="com26.js"></script>
<script src="com27.js"></script>
<script src="com28.js"></script>
<script src="com29.js"></script>
<script src="com30.js"></script>
<script src="com31.js"></script>
<script src="com32.js"></script>
<script src="com33.js"></script>

<p class="small-left">
  Maxima Online 2 - version 1.0 -  
  <a href="https://maxima-french-doc.fr/interfaces/" target = "_blank">Site du logiciel</a> - 
  <a href="check_version.php">Vérifier les mises à jour</a>
  <br>
  Maxima Online 2 est basé sur le code de Yamwi, écrit par Leo Butler : 
  <a href="https://github.com/leo-butler/yamwi/" target = "_blank">Yamwi Source</a>
  <br>
  Distribué sous licence GNU GENERAL PUBLIC LICENSE (GPL) v3.0
</p>


</body>
</html>

